/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware.novacom;

import ca.canucksoftware.utils.TextStreamConsumer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class Novacom {
    public static String execPath() {
        String novacom = "novacom";
        if (new File("/usr/local/bin/novacom").exists()) {
            novacom = "/usr/local/bin/novacom";
        } else if (new File("/opt/nova/bin/novacom").exists()) {
            novacom = "/opt/nova/bin/novacom";
        } else {
            String programPath32 = System.getenv("ProgramFiles");
            String programPath64 = null;
            if (programPath32 != null) {
                if ((programPath32 = programPath32.replace("\\", "/").trim()).endsWith("(x86)")) {
                    programPath64 = programPath32.substring(0, programPath32.lastIndexOf("(x86)")).trim();
                    programPath64 = programPath64.replace("\\", "/");
                }
                if (programPath64 != null && new File(programPath64 + "/HP webOS/SDK/bin/novacom.exe").exists()) {
                    novacom = programPath64 + "/HP webOS/SDK/bin/novacom.exe";
                } else if (new File(programPath32 + "/HP webOS/SDK/bin/novacom.exe").exists()) {
                    novacom = programPath32 + "/HP webOS/SDK/bin/novacom.exe";
                } else if (programPath64 != null && new File(programPath64 + "/Palm, Inc/novacom.exe").exists()) {
                    novacom = programPath64 + "/Palm, Inc/novacom.exe";
                } else if (new File(programPath32 + "/Palm, Inc/novacom.exe").exists()) {
                    novacom = programPath32 + "/Palm, Inc/novacom.exe";
                } else if (programPath64 != null && new File(programPath64 + "/Palm, Inc/novacom/novacom.exe").exists()) {
                    novacom = programPath64 + "/Palm, Inc/novacom/novacom.exe";
                } else if (new File(programPath32 + "/Palm, Inc/novacom/novacom.exe").exists()) {
                    novacom = programPath32 + "/Palm, Inc/novacom/novacom.exe";
                } else if (programPath64 != null && new File(programPath64 + "/Palm/SDK/bin/novacom.exe").exists()) {
                    novacom = programPath64 + "/Palm/SDK/bin/novacom.exe";
                } else if (new File(programPath32 + "/Palm/SDK/bin/novacom.exe").exists()) {
                    novacom = programPath32 + "/Palm/SDK/bin/novacom.exe";
                } else if (programPath64 != null && new File(programPath64 + "/PDK/bin/novacom.exe").exists()) {
                    novacom = programPath64 + "/PDK/bin/novacom.exe";
                } else if (new File(programPath32 + "/PDK/bin/novacom.exe").exists()) {
                    novacom = programPath32 + "/PDK/bin/novacom.exe";
                }
            } else if (new File("C:/Program Files/HP webOS/SDK/bin/novacom.exe").exists()) {
                novacom = "C:/Program Files/HP webOS/SDK/bin/novacom.exe";
            } else if (new File("C:/Program Files/Palm, Inc/novacom.exe").exists()) {
                novacom = "C:/Program Files/Palm, Inc/novacom.exe";
            } else if (new File("C:/Program Files/Palm, Inc/novacom/novacom.exe").exists()) {
                novacom = "C:/Program Files/Palm, Inc/novacom/novacom.exe";
            } else if (new File("C:/Program Files/Palm/SDK/bin/novacom.exe").exists()) {
                novacom = "C:/Program Files/Palm/SDK/bin/novacom.exe";
            } else if (new File("C:/Program Files/PDK/bin/novacom.exe").exists()) {
                novacom = "C:/Program Files/PDK/bin/novacom.exe";
            }
        }
        return novacom;
    }

    public static boolean isInstalled() {
        boolean isInstalled = false;
        String execPath = Novacom.execPath();
        if (execPath.equals("novacom")) {
            try {
                Process p = Runtime.getRuntime().exec("novacom -l");
                OutputStream os = p.getOutputStream();
                os.flush();
                os.close();
                TextStreamConsumer stdout = new TextStreamConsumer(p.getInputStream());
                stdout.start();
                TextStreamConsumer stderr = new TextStreamConsumer(p.getErrorStream());
                stderr.start();
                stdout.waitFor();
                isInstalled = p.waitFor() == 0;
            }
            catch (Exception exception) {}
        } else {
            isInstalled = new File(execPath).exists();
        }
        return isInstalled;
    }

    public static boolean serviceInstalled() {
        boolean installed = false;
        if (new File("/opt/Palm/novacom/novacomd").exists()) {
            installed = true;
        } else if (new File("/opt/nova/bin/novacomd").exists() || new File("/Library/LaunchDaemons/com.palm.novacomd").exists()) {
            installed = true;
        } else {
            String programPath32 = System.getenv("ProgramFiles");
            String programPath64 = null;
            if (programPath32 != null) {
                if ((programPath32 = programPath32.replace("\\", "/").trim()).endsWith("(x86)")) {
                    programPath64 = programPath32.substring(0, programPath32.lastIndexOf("(x86)")).trim();
                    programPath64 = programPath64.replace("\\", "/");
                }
                if (new File(programPath32 + "/HP webOS/SDK/bin/novacomd/amd64/novacomd.exe").exists() || new File(programPath32 + "/HP webOS/SDK/bin/novacomd/x86/novacomd.exe").exists() || new File(programPath32 + "/Palm, Inc/novacom/amd64/novacomd.exe").exists() || new File(programPath32 + "/Palm, Inc/novacom/x86/novacomd.exe").exists() || new File(programPath32 + "/Palm/SDK/novacom/amd64/novacomd.exe").exists() || new File(programPath32 + "/Palm/SDK/novacom/x86/novacomd.exe").exists() || new File(programPath32 + "/Palm/SDK/bin/novacom/amd64/novacomd.exe").exists() || new File(programPath32 + "/Palm/SDK/bin/novacom/x86/novacomd.exe").exists()) {
                    installed = true;
                }
                if (programPath64 != null && (new File(programPath64 + "/HP webOS/SDK/bin/novacomd/amd64/novacomd.exe").exists() || new File(programPath64 + "/HP webOS/SDK/bin/novacomd/x86/novacomd.exe").exists() || new File(programPath64 + "/Palm, Inc/novacom/amd64/novacomd.exe").exists() || new File(programPath64 + "/Palm, Inc/novacom/x86/novacomd.exe").exists() || new File(programPath64 + "/Palm/SDK/novacom/amd64/novacomd.exe").exists() || new File(programPath64 + "/Palm/SDK/novacom/x86/novacomd.exe").exists() || new File(programPath64 + "/Palm/SDK/bin/novacom/amd64/novacomd.exe").exists() || new File(programPath64 + "/Palm/SDK/bin/novacom/x86/novacomd.exe").exists())) {
                    installed = true;
                }
            } else if (new File("C:/Program Files/HP webOS/SDK/bin/novacomd/amd64/novacomd.exe").exists() || new File("C:/Program Files/HP webOS/SDK/bin/novacomd/x86/novacomd.exe").exists() || new File("C:/Program Files/Palm, Inc/novacom/amd64/novacomd.exe").exists() || new File("C:/Program Files/Palm, Inc/novacom/x86/novacomd.exe").exists() || new File("C:/Program Files/Palm/SDK/novacom/amd64/novacomd.exe").exists() || new File("C:/Program Files/Palm/SDK/novacom/x86/novacomd.exe").exists() || new File("C:/Program Files/Palm/SDK/bin/novacom/amd64/novacomd.exe").exists() || new File("C:/Program Files/Palm/SDK/bin/novacom/x86/novacomd.exe").exists()) {
                installed = true;
            }
        }
        if (!installed) {
            try {
                Process p = Runtime.getRuntime().exec("novacom -l");
                OutputStream os = p.getOutputStream();
                os.flush();
                os.close();
                TextStreamConsumer stdout = new TextStreamConsumer(p.getInputStream());
                stdout.start();
                TextStreamConsumer stderr = new TextStreamConsumer(p.getErrorStream());
                stderr.start();
                stdout.waitFor();
                installed = p.waitFor() == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return installed;
    }

    public static void restartService() {
        Process restarter = null;
        try {
            String platform = System.getProperty("os.name").toLowerCase();
            if (platform.contains("windows")) {
                restarter = Runtime.getRuntime().exec("net stop novacomd");
                Novacom.doProcess(restarter);
                restarter = Runtime.getRuntime().exec("net start novacomd");
                Novacom.doProcess(restarter);
            } else if (platform.contains("mac")) {
                restarter = Runtime.getRuntime().exec("/usr/local/bin/stop-novacomd");
                Novacom.doProcess(restarter);
                restarter = Runtime.getRuntime().exec("/usr/local/bin/start-novacomd");
                Novacom.doProcess(restarter);
            } else if (platform.contains("linux")) {
                restarter = Runtime.getRuntime().exec("stop palm-novacomd");
                Novacom.doProcess(restarter);
                restarter = Runtime.getRuntime().exec("killall -v -q novacomd");
                Novacom.doProcess(restarter);
                restarter = Runtime.getRuntime().exec("start palm-novacomd");
                Novacom.doProcess(restarter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean doProcess(Process p) throws IOException, InterruptedException {
        OutputStream os = p.getOutputStream();
        os.flush();
        os.close();
        TextStreamConsumer stdout = new TextStreamConsumer(p.getInputStream());
        stdout.start();
        TextStreamConsumer stderr = new TextStreamConsumer(p.getErrorStream());
        stderr.start();
        int exitCode = p.waitFor();
        stdout.waitFor();
        stderr.waitFor();
        return exitCode == 0;
    }
}

