/*
 * Decompiled with CFR 0.152.
 */
package ca.canucksoftware.novacom;

import ca.canucksoftware.utils.TextStreamConsumer;
import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.NumberFormat;
import java.util.zip.GZIPInputStream;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class NovacomDrivers {
    private Driver driver;
    private JProgressBar pBar = null;
    private JLabel label = null;

    public NovacomDrivers() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            this.driver = System.getenv("ProgramFiles(x86)") == null ? Driver.Windows_x86 : Driver.Windows_x64;
        } else if (os.contains("mac")) {
            this.driver = Driver.Mac;
        } else if (os.contains("linux")) {
            this.driver = !this.is64bitLinux() ? Driver.Linux_x86 : Driver.Linux_x64;
        }
    }

    public void setGUI(JLabel lbl, JProgressBar bar) {
        this.label = lbl;
        this.pBar = bar;
    }

    private boolean is64bitLinux() {
        boolean result = false;
        try {
            Process p = Runtime.getRuntime().exec("dpkg --print-architecture");
            OutputStream os = p.getOutputStream();
            os.flush();
            os.close();
            TextStreamConsumer stdout = new TextStreamConsumer(p.getInputStream());
            stdout.start();
            TextStreamConsumer stderr = new TextStreamConsumer(p.getErrorStream());
            stderr.start();
            stdout.waitFor();
            result = !stdout.toString().toLowerCase().contains("i386");
        }
        catch (IOException e) {
            System.err.println("Unable to check Linux system architecture");
        }
        return result;
    }

    public boolean install() {
        boolean result = false;
        if (this.driver == Driver.Windows_x86 || this.driver == Driver.Windows_x64) {
            result = this.installForWindows();
        } else if (this.driver == Driver.Mac) {
            result = this.installForMac();
        } else if (this.driver == Driver.Linux_x86 || this.driver == Driver.Linux_x64) {
            result = this.installForLinux();
        }
        return result;
    }

    public boolean installForWindows() {
        boolean result = false;
        File installer = this.extractInstaller();
        if (installer != null) {
            if (this.label != null) {
                this.label.setText("<html>Installing driver...");
            }
            String command = "msiexec /i " + installer.getAbsolutePath() + " /passive";
            if (this.isStandaloneInstalled()) {
                command = "msiexec /i " + installer.getAbsolutePath() + " REINSTALL=ALL REINSTALLMODE=vomus /norestart /passive";
            }
            try {
                Process p = Runtime.getRuntime().exec(command);
                OutputStream os = p.getOutputStream();
                os.flush();
                os.close();
                TextStreamConsumer stdout = new TextStreamConsumer(p.getInputStream());
                stdout.start();
                TextStreamConsumer stderr = new TextStreamConsumer(p.getErrorStream());
                stderr.start();
                result = p.waitFor() == 0;
                stdout.waitFor();
                stderr.waitFor();
                installer.delete();
                result = true;
            }
            catch (Exception e) {
                System.err.println("Unable to install " + this.driver.file());
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean installForMac() {
        boolean result = false;
        File installer = this.extractInstaller();
        if (installer != null) {
            if (this.label != null) {
                this.label.setText("<html>Installing driver...");
            }
            try {
                Process p = Runtime.getRuntime().exec("open -W " + installer.getAbsolutePath());
                OutputStream os = p.getOutputStream();
                os.flush();
                os.close();
                TextStreamConsumer stdout = new TextStreamConsumer(p.getInputStream());
                stdout.start();
                TextStreamConsumer stderr = new TextStreamConsumer(p.getErrorStream());
                stderr.start();
                result = p.waitFor() == 0;
                stdout.waitFor();
                stderr.waitFor();
                this.deleteItem(installer);
                result = true;
            }
            catch (Exception e) {
                System.err.println("Unable to install " + this.driver.file());
            }
        }
        return result;
    }

    private boolean deleteItem(File path) {
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteItem(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public boolean installForLinux() {
        boolean result = false;
        File installer = this.extractInstaller();
        if (installer != null) {
            if (this.label != null) {
                this.label.setText("<html>Installing driver...");
            }
            if (installer != null) {
                try {
                    Process p = Runtime.getRuntime().exec("xterm +hold -e sudo dpkg -i " + installer.getAbsolutePath());
                    OutputStream os = p.getOutputStream();
                    os.flush();
                    os.close();
                    TextStreamConsumer stdout = new TextStreamConsumer(p.getInputStream());
                    stdout.start();
                    TextStreamConsumer stderr = new TextStreamConsumer(p.getErrorStream());
                    stderr.start();
                    result = p.waitFor() == 0;
                    stdout.waitFor();
                    stderr.waitFor();
                    installer.delete();
                    result = true;
                }
                catch (Exception e) {
                    System.err.println("Unable to install " + this.driver.file());
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private File extractInstaller() {
        String tmpFilePath = System.getProperty("java.io.tmpdir");
        File result = new File(tmpFilePath, this.driver.file());
        if (result.exists()) {
            this.deleteItem(result);
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(2);
        TarInputStream tis = null;
        try {
            HttpURLConnection urlCon = (HttpURLConnection)new URL(this.driver.url()).openConnection();
            urlCon.setInstanceFollowRedirects(true);
            urlCon.setRequestProperty("REFERER", this.driver.url());
            urlCon.connect();
            tis = new TarInputStream(new GZIPInputStream(urlCon.getInputStream()));
            TarEntry entry = tis.getNextEntry();
            byte[] data = new byte[2048];
            int count = 0;
            int kbCount = 0;
            while (entry != null) {
                if (!entry.getName().endsWith("hp_license_agreement.pdf")) {
                    File curr = new File(tmpFilePath, entry.getName());
                    if (entry.isDirectory()) {
                        curr.mkdirs();
                    } else {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(curr));
                        while ((count = tis.read(data)) != -1) {
                            if (this.label != null) {
                                if (kbCount < 1000) {
                                    this.pBar.setString(kbCount + " KB");
                                } else {
                                    this.pBar.setString(nf.format((double)kbCount / 1024.0) + " MB");
                                }
                            }
                            kbCount += 2;
                            ((OutputStream)out).write(data, 0, count);
                        }
                        ((OutputStream)out).flush();
                        ((OutputStream)out).close();
                        if (this.driver == Driver.Mac) {
                            try {
                                Process p = Runtime.getRuntime().exec("chmod ugoa+x " + curr.getAbsolutePath());
                                OutputStream os = p.getOutputStream();
                                os.flush();
                                os.close();
                                TextStreamConsumer stdout = new TextStreamConsumer(p.getInputStream());
                                stdout.start();
                                TextStreamConsumer stderr = new TextStreamConsumer(p.getErrorStream());
                                stderr.start();
                                p.waitFor();
                                stdout.waitFor();
                                stderr.waitFor();
                            }
                            catch (Exception e) {
                                System.err.println("Unable to chmod " + curr.getAbsolutePath());
                            }
                        }
                    }
                }
                entry = tis.getNextEntry();
            }
            tis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Unable to extract " + this.driver.file());
            result = null;
        }
        return result;
    }

    private boolean isStandaloneInstalled() {
        boolean installed = false;
        if (new File("/opt/Palm/novacom/novacomd").exists()) {
            installed = true;
        } else if (new File("/opt/nova/bin/novacomd").exists() || new File("/Library/LaunchDaemons/com.palm.novacomd").exists()) {
            installed = true;
        } else {
            String programPath32 = System.getenv("ProgramFiles");
            String programPath64 = null;
            if (programPath32 != null) {
                if ((programPath32 = programPath32.replace("\\", "/").trim()).endsWith("(x86)")) {
                    programPath64 = programPath32.substring(0, programPath32.lastIndexOf("(x86)")).trim();
                    programPath64 = programPath64.replace("\\", "/");
                }
                if (new File(programPath32 + "/Palm, Inc/novacom/amd64/novacomd.exe").exists() || new File(programPath32 + "/Palm, Inc/novacom/x86/novacomd.exe").exists()) {
                    installed = true;
                }
                if (programPath64 != null && (new File(programPath64 + "/Palm, Inc/novacom/amd64/novacomd.exe").exists() || new File(programPath64 + "/Palm, Inc/novacom/x86/novacomd.exe").exists())) {
                    installed = true;
                }
            } else if (new File("C:/Program Files/Palm, Inc/novacom/amd64/novacomd.exe").exists() || new File("C:/Program Files/Palm, Inc/novacom/x86/novacomd.exe").exists()) {
                installed = true;
            }
        }
        return installed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Driver {
        Windows_x86("NovacomInstaller_x86.msi", "http://downloads.help.palm.com/opensource/novacom/novacom-win-32.tgz"),
        Windows_x64("NovacomInstaller_x64.msi", "http://downloads.help.palm.com/opensource/novacom/novacom-win-64.tgz"),
        Mac("NovacomInstaller.pkg", "http://downloads.help.palm.com/opensource/novacom/novacom-mac.tgz"),
        Linux_x86("palm-novacom_1.0.76_i386.deb", "http://downloads.help.palm.com/opensource/novacom/novacom-linux-32.tgz"),
        Linux_x64("palm-novacom_1.0.76_amd64.deb", "http://downloads.help.palm.com/opensource/novacom/novacom-linux-64.tgz");

        private String file;
        private String url;

        private Driver(String file, String url) {
            this.file = file;
            this.url = url;
        }

        public String file() {
            return this.file;
        }

        public String url() {
            return this.url;
        }
    }
}

