#!/bin/bash

#pushd `dirname $0` > /dev/null
#SCRIPTPATH=/home/koc/Escritorio/koc_install
#popd > /dev/null

# Get the path where this script is running from
SCRIPTPATH="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
echo "Executing from $SCRIPTPATH ..."

echo "================================"
echo "= Setting KoC Background       ="
echo "================================"
# Copy files into system wallpaper folder
sudo cp $SCRIPTPATH/wallpaper/kids_logo_350.png /usr/share/lubuntu/wallpapers/
sudo cp $SCRIPTPATH/wallpaper/kids_logo_500.png /usr/share/lubuntu/wallpapers/
sudo cp $SCRIPTPATH/wallpaper/kids_logo_700.png /usr/share/lubuntu/wallpapers/
sudo cp $SCRIPTPATH/wallpaper/kids_logo_900.png /usr/share/lubuntu/wallpapers/
# Update config file for background color
sed -i "s|desktop_bg.*|desktop_bg=#f9f9f9|g" /home/koc/.config/pcmanfm/lubuntu/desktop-items-0.conf

# Set background mode to "center"
sudo -u koc pcmanfm --wallpaper-mode=center

# Set background image
sudo -u koc pcmanfm --set-wallpaper /usr/share/lubuntu/wallpapers/kids_logo_700.png


echo "================================"
echo "= KoC Package Installation     ="
echo "================================"
echo "Installing updates and educational packages from $SCRIPTPATH ..."
sudo dpkg -i $SCRIPTPATH/packages/*

echo "================================"
echo "= Installing Flash Plugin      ="
echo "=    (Mozilla/Firefox)         =";
echo "================================"
sudo /bin/cp -f $SCRIPTPATH/flashplugin/i386/libflashplayer.so /usr/lib/mozilla/plugins/

echo "================================"
echo "= Installing Pepper Flash      ="
echo "=    (Chromium)                =";
echo "================================"
sudo /bin/mkdir -p /usr/lib/pepperflashplugin-nonfree/
sudo /bin/cp -f $SCRIPTPATH/pepperflash/i386/* /usr/lib/pepperflashplugin-nonfree/

echo " "
echo "********************************"
echo "Done.                           "
echo "  Please reboot and verify now. "
echo "  After verification, remove    "
echo "  installation folder from      "
echo "  desktop.                      "
echo "********************************"
