
/* gettext library */

var catalog = new Array();

function pluralidx(n) {
  var v=(n != 1);
  if (typeof(v) == 'boolean') {
    return v ? 1 : 0;
  } else {
    return v;
  }
}
catalog['%(points)d points!'] = '%(points)d puntos!';
catalog['%(subtitle_count)d Subtitles / %(percent_translated)d%% Translated'] = '%(subtitle_count)d Subtitulos / %(percent_translated)d%% Traducidos';
catalog['%(username)s (Logout)'] = '%(username)s (Salir)';
catalog['An error occurred while contacting the server to start the download process'] = 'Error al entrar en contacto con el servidor para iniciar el proceso de descarga';
catalog['Completed update successfully.'] = 'Complet\u00f3 la actualizaci\u00f3n correctamente.';
catalog['Could not connect to the server.'] = 'No se pudo conectar al servidor.';
catalog['Delete %(vid_count)d selected video(s)'] = 'Eliminar %(vid_count)d video(s) seleccionado(s)';
catalog['Download %(vid_count)d new selected video(s)'] = 'Descargar %(vid_count)d video(s) nuevos';
catalog['Download for language %s started.'] = 'La descarga de lenguaje %s ha iniciado.';
catalog['Error canceling downloads'] = 'Error al cancelar descargas';
catalog['Error downloading subtitles'] = 'Error al descargar subt\u00edtulos';
catalog['Error downloading videos'] = 'Error descargando v\u00eddeos';
catalog['Error during update: %(progress_log_notes)s'] = 'Error durante la actualizaci\u00f3n: %(progress_log_notes)s';
catalog['Error getting search data'] = 'Error obteniendo datos de b\u00fasqueda';
catalog['Error restarting downloads'] = 'Error reiniciando descargas';
catalog['Error starting updates process'] = 'Error iniciando procesos de actualizaci\u00f3n';
catalog['Error starting video download'] = 'Error iniciando descarga de video';
catalog['Error while checking update status: %(message)s'] = 'Error al comprobar el estado de actualizaci\u00f3n: %(message)s';
catalog['None; Please select now'] = 'Ninguno; Por favor, elegir ahora';
catalog['Overall progress: %(percent_complete)5.2f%% complete (%(cur_stage)d of %(num_stages)d)'] = 'Progreso total: %(percent_complete)5.2f%% completo (%(cur_stage)d de %(num_stages)d)';
catalog['Set as default'] = 'Establecer como predeterminado';
catalog['Subtitles'] = 'Subt\u00edtulos';
catalog['Successfully launched data syncing job. After syncing completes, visit the <a href=\'/management/device/\'>device management page</a> to view results.'] = 'Lanz\u00f3 con \u00e9xito el trabajo de sincronizaci\u00f3n de datos. Tras completar la sincronizaci\u00f3n, visite la <a href=\'/management/device/\'> p\u00e1gina de administraci\u00f3n de dispositivos</a> para ver los resultados.';
catalog['The server does not have internet access; new content cannot be downloaded at this time.'] = 'El servidor no tiene acceso a internet; el nuevo contenido no puede descargarse en este momento.';
catalog['Total Points : %(points)d '] = 'Puntaje total: %(points)d ';
catalog['Translated'] = 'Traducido';
catalog['Unexpected error: no search data found for selected item. Please select another item.'] = 'Error inesperado: no se encontraron datos para el elemento seleccionado. Por favor seleccione otro elemento.';
catalog['Uninterpretable message received.'] = 'Se recibi\u00f3 un mensaje no entendible.';
catalog['Update cancelled successfully.'] = 'Actualizaci\u00f3n cancelada con \u00e9xito.';
catalog['Upgrade'] = 'Actualizar';
catalog['You are not authorized to complete the request.  Please <a href=\'/securesync/login/\' target=\'_blank\'>login</a> as an administrator, then retry.'] = 'Usted no est\u00e1 autorizado para completar la solicitud.  Por favor <a href=\'/securesync/login/\' target=\'_blank\'>login</a> como administrador y vuelva a intentarlo.';
catalog['problem on server.'] = 'problema en el servidor.';


function gettext(msgid) {
  var value = catalog[msgid];
  if (typeof(value) == 'undefined') {
    return msgid;
  } else {
    return (typeof(value) == 'string') ? value : value[0];
  }
}

function ngettext(singular, plural, count) {
  value = catalog[singular];
  if (typeof(value) == 'undefined') {
    return (count == 1) ? singular : plural;
  } else {
    return value[pluralidx(count)];
  }
}

function gettext_noop(msgid) { return msgid; }

function pgettext(context, msgid) {
  var value = gettext(context + '' + msgid);
  if (value.indexOf('') != -1) {
    value = msgid;
  }
  return value;
}

function npgettext(context, singular, plural, count) {
  var value = ngettext(context + '' + singular, context + '' + plural, count);
  if (value.indexOf('') != -1) {
    value = ngettext(singular, plural, count);
  }
  return value;
}

function interpolate(fmt, obj, named) {
  if (named) {
    return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
  } else {
    return fmt.replace(/%s/g, function(match){return String(obj.shift())});
  }
}

/* formatting library */

var formats = new Array();

formats['DATETIME_FORMAT'] = 'N j, Y, P';
formats['DATE_FORMAT'] = 'N j, Y';
formats['DECIMAL_SEPARATOR'] = '.';
formats['MONTH_DAY_FORMAT'] = 'F j';
formats['NUMBER_GROUPING'] = '0';
formats['TIME_FORMAT'] = 'P';
formats['FIRST_DAY_OF_WEEK'] = '0';
formats['TIME_INPUT_FORMATS'] = ['%H:%M:%S', '%H:%M'];
formats['THOUSAND_SEPARATOR'] = ',';
formats['DATE_INPUT_FORMATS'] = ['%Y-%m-%d', '%m/%d/%Y', '%m/%d/%y', '%b %d %Y', '%b %d, %Y', '%d %b %Y', '%d %b, %Y', '%B %d %Y', '%B %d, %Y', '%d %B %Y', '%d %B, %Y'];
formats['YEAR_MONTH_FORMAT'] = 'F Y';
formats['SHORT_DATE_FORMAT'] = 'm/d/Y';
formats['SHORT_DATETIME_FORMAT'] = 'm/d/Y P';
formats['DATETIME_INPUT_FORMATS'] = ['%Y-%m-%d %H:%M:%S', '%Y-%m-%d %H:%M:%S.%f', '%Y-%m-%d %H:%M', '%Y-%m-%d', '%m/%d/%Y %H:%M:%S', '%m/%d/%Y %H:%M:%S.%f', '%m/%d/%Y %H:%M', '%m/%d/%Y', '%m/%d/%y %H:%M:%S', '%m/%d/%y %H:%M:%S.%f', '%m/%d/%y %H:%M', '%m/%d/%y'];

function get_format(format_type) {
    var value = formats[format_type];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return value;
    }
}
