#!/bin/bash

SCRIPTPATH="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
echo "Executing from $SCRIPTPATH ..."

##################################
# Create target directories
echo "============================================"
echo "= Creating directories for RACHEL content  ="
echo "============================================"
sudo mkdir -p /opt/wikipedia/
sudo chown koc.koc /opt/wikipedia/
sudo mkdir -p /opt/ka-lite/content/
sudo chown -R koc.koc /opt/ka-lite
sudo mkdir -p /var/www/

##################################
# Install packages
echo "============================================"
echo "= Installing additional .deb packages      ="
echo "=  (kiwix, etc.)                           ="
echo "============================================"
sudo dpkg -i $SCRIPTPATH/packages/*.deb

##################################
# Initialize base RACHEL content
echo "============================================"
echo "= Initializing RACHEL content in /var/www/ ="
echo "============================================"
sudo cp $SCRIPTPATH/index.html /var/www/

##################################
# Initialize KALite infrastruture
echo "============================================"
echo "= Initializing KALite server files         ="
echo "============================================"
tar -C /opt/ka-lite -xf ka-lite-skel.tgz

##################################
# End of Setup
##################################
echo "********************************************"
echo "* Phase 1 Complete!                        *"
echo "*                                          *"
echo "* Refer to README.install for manual steps *"
echo "* to execute before proceeding to Phase 2  *"
echo "*                                          *"
echo "********************************************"


