#!/bin/bash

SCRIPTPATH="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
echo "Executing from $SCRIPTPATH ..."

##################################
# (Re)Create target directories
echo "============================================"
echo "= Creating directories for RACHEL content  ="
echo "============================================"
sudo mkdir -p /opt/wikipedia/
chown -R koc.koc /opt/wikipedia/
sudo mkdir -p /opt/ka-lite/content/
chown -R koc.koc /opt/ka-lite
sudo mkdir -p /var/www/

##################################
# Setup apache conf
echo "============================================"
echo "= Configuring Apache server (serve base    ="
echo "= RACHEL content from /var/www/; proxy for ="
echo "= wikipedia on port 8080)                  ="
echo "============================================"
sudo iptables -A INPUT -p tcp --dport 80 -j ACCEPT
sudo /bin/cp -f $SCRIPTPATH/conf/etc_apache2_sites-available_default.rachel.conf /etc/apache2/sites-available/default.rachel.conf
sudo a2dissite default
sudo a2dissite 000-default
sudo a2ensite default.rachel
sudo a2enmod proxy_http
sudo update-rc.d apache2 defaults
sudo service apache2 restart

##################################
# Modify link to KALite server
#  (was 8008, needs to be 7007)
echo "============================================"
echo "= Updating RACHEL link to KALite server    ="
echo "= port in /var/www/index.html. (Change     ="
echo "= from 7007 to 8008)                       ="
echo "============================================"
sudo sed -i 's/7007/8008/g' /var/www/index.html

##################################
# Setup Kiwix server
echo "============================================"
echo "= Configuring Kiwix server (serves         ="
echo "= wikipedia content from port 8080)        ="
echo "============================================"
sudo /bin/cp -f $SCRIPTPATH/conf/etc_init.d_kiwix /etc/init.d/kiwix
sudo chmod a+x /etc/init.d/kiwix
sudo update-rc.d kiwix defaults
sudo service kiwix start
sudo iptables -A INPUT -p tcp --dport 8080 -j ACCEPT

##################################
# Setup KALite server
echo "============================================"
echo "= Configuring KALite server (serves KA     ="
echo "= content from port 7007)                  ="
echo "============================================"
sudo iptables -A INPUT -p tcp --dport 7007 -j ACCEPT
sudo /bin/bash /opt/ka-lite/setup_linux.sh
# Note:  Start the server as a normal user, not with sudo
/opt/ka-lite/start.sh

##################################
# Setup KALite Admin User
echo "============================================"
echo "= Creating KALite Administrator Account    ="
echo "============================================"
KALITE_USER=kocadmin
/opt/ka-lite/kalite/manage.py createsuperuser --noinput --username=$KALITE_USER --email=kalite-mexico2014@kidsoncomputers.org
echo "=========================================================>"
echo "===> Please create a password for user '$KALITE_USER' ===>"
echo "===> After creating password, please write down both  ===>"
echo "===> username (kocadmin) and password values          ===>"
/opt/ka-lite/kalite/manage.py changepassword $KALITE_USER
echo " "


##################################
# End of Setup
##################################
echo "********************************************"
echo "* Setup Complete!                          *"
echo "*                                          *"
echo "* Open a browser and go to:                *"
echo "*  http://localhost                        *"
echo "*                                          *"
echo "* Login to KA Lite; setup class/students   *"
echo "*  http://localhost:8008                   *"
echo "*                                          *"
echo "********************************************"



